#!/bin/bash

DebVersion=1.0.43
RpmVersion=1.0-43
packageName=printer-driver-nantian-bl35x0dn
ShortName=nt

##########################################
CpuArch=$(sudo uname -m)
echo "CPU arch: ${CpuArch}."
KernelVersion=`sudo uname -r | cut -d"." -f1,1`
echo "Kernel version: ${KernelVersion}."
OsInfo=`grep '^PRETTY_NAME=' /etc/os-release | cut -d"\"" -f2,2`
echo "OS: ${OsInfo}"
CheckDeb=$(command -v dpkg)
CheckRpm=$(command -v rpm)

if [ -e "${CheckDeb}" ]; then
    echo "deb package manager."
    if [[ "${CpuArch}" == *"x86_64"* ]]; then
        echo "\e[34m[x86_64]\e[0m"
        if [ -e ./deb/${packageName}_${DebVersion}_l${KernelVersion}_amd64.deb ]; then
            echo "found\e[33m[${packageName}_${DebVersion}_l${KernelVersion}_amd64.deb]\e[0m package."
            sudo dpkg -i ./deb/${packageName}_${DebVersion}_l${KernelVersion}_amd64.deb
        else
            echo "\e[31m[${packageName}_${DebVersion}_l${KernelVersion}_amd64.deb]\e[0m"
            echo "\e[31m ↑↑↑ target deb no found! \e[0m"
        fi
    fi

    if [[ "${CpuArch}" == *"aarch64"* ]]; then
        echo "\e[34m[arm64]\e[0m"
        if [ -e ./deb/${packageName}_${DebVersion}_l${KernelVersion}_arm64.deb ]; then
            echo "found\e[33m[${packageName}_${DebVersion}_l${KernelVersion}_arm64.deb]\e[0m package."
            sudo dpkg -i ./deb/${packageName}_${DebVersion}_l${KernelVersion}_arm64.deb
        else
            echo "\e[31m[${packageName}_${DebVersion}_l${KernelVersion}_arm64.deb]\e[0m"
            echo "\e[31m ↑↑↑ target deb no found! \e[0m"
        fi
    fi   
    
    if [[ "${CpuArch}" == *"loongarch64"* ]]; then
        echo "\e[34m[loongarch64]\e[0m"
        if [ -e ./deb/${packageName}_${DebVersion}_l${KernelVersion}_loongarch64.deb ]; then
            echo "found\e[33m[${packageName}_${DebVersion}_l${KernelVersion}_loongarch64.deb]\e[0m package."
            sudo dpkg -i ./deb/${packageName}_${DebVersion}_l${KernelVersion}_loongarch64.deb
        else
            echo "\e[31m[${packageName}_${DebVersion}_l${KernelVersion}_loongarch64.deb]\e[0m"
            echo "\e[31m ↑↑↑ target deb no found! \e[0m"
        fi
    fi

    if [[ "${CpuArch}" == *"mips64"* ]]; then
        echo "\e[34m[mips64]\e[0m"
        lsb_release -i | grep "Loongnix"
        if [ $? -ne 0 ]; then
            echo "not Loongnix OS, use common mips64."
            if [ -e ./deb/${packageName}_${DebVersion}_l${KernelVersion}_mips64el.deb ]; then
                echo "found\e[33m[${packageName}_${DebVersion}_l${KernelVersion}_mips64el.deb]\e[0m package."
                sudo dpkg -i ./deb/${packageName}_${DebVersion}_l${KernelVersion}_mips64el.deb
	     else
                echo "\e[31m[${packageName}_${DebVersion}_l${KernelVersion}_mips64el.deb]\e[0m"
                echo "\e[31m ↑↑↑ target deb no found! \e[0m"
	     fi
        else
            echo "Loongnix OS."
            lscpu | grep "3A4000"
            if [ $? -ne 0 ]; then
                lscpu | grep "3A3000"
                if [ $? -ne 0 ]; then
                    echo "not 3A3000 and 3A4000 CPU, will support later."
                else
                    if [ -e ./deb/${packageName}_${DebVersion}_l${KernelVersion}_mips64el-loongnix-3A3000.deb ]; then
                        echo "found\e[33m[${packageName}_${DebVersion}_l${KernelVersion}_mips64el-loongnix-3A3000.deb]\e[0m package."
                        sudo dpkg -i ./deb/${packageName}_${DebVersion}_l${KernelVersion}_mips64el-loongnix-3A3000.deb
                    else
                        echo "\e[31m[${packageName}_${DebVersion}_l${KernelVersion}_mips64el-loongnix-3A3000.deb]\e[0m"
                        echo "\e[31m ↑↑↑ target deb no found! \e[0m"
                    fi
                fi
            else
                if [ -e ./deb/${packageName}_${DebVersion}_l${KernelVersion}_mips64el-loongnix-3A4000.deb ]; then
                    echo "found\e[33m[${packageName}_${DebVersion}_l${KernelVersion}_mips64el-loongnix-3A4000.deb]\e[0m package."
                    sudo dpkg -i ./deb/${packageName}_${DebVersion}_l${KernelVersion}_mips64el-loongnix-3A4000.deb
	         else
	            echo "\e[31m[${packageName}_${DebVersion}_l${KernelVersion}_mips64el-loongnix-3A4000.deb]\e[0m"
	            echo "\e[31m ↑↑↑ target deb no found! \e[0m"
	         fi
            fi
        fi	
    fi
    
    if [[ "${CpuArch}" == *"sw_64"* ]]; then
        echo "\e[34m[sw_64]\e[0m"
        if [ -e ./deb/${packageName}_${DebVersion}_l${KernelVersion}_sw_64.deb ]; then
            echo "found\e[33m[${packageName}_${DebVersion}_l${KernelVersion}_sw_64.deb]\e[0m package."
            sudo dpkg -i ./deb/${packageName}_${DebVersion}_l${KernelVersion}_sw_64.deb
        else
            echo "\e[31m[${packageName}_${DebVersion}_l${KernelVersion}_sw_64.deb]\e[0m"
            echo "\e[31m ↑↑↑ target deb no found! \e[0m"
        fi
    fi
    sudo systemctl stop NetworkManager
#    sleep 3
    sudo test -d /etc/network/if-up.d && sudo cp -f ./tools/resetusbnicmetricdeb /etc/network/if-up.d/resetusbnicmetric${ShortName}
    sudo chmod 755 /etc/network/if-up.d/resetusbnicmetric${ShortName}
    sudo test -d /etc/NetworkManager/dispatcher.d && sudo cp -f ./tools/resetusbnicmetricrpm /etc/NetworkManager/dispatcher.d/resetusbnicmetric${ShortName} 
    sudo systemctl start NetworkManager

# 检查 rpm 命令是否存在
elif [ -e "${CheckRpm}" ]; then
    echo "rpm package manager."
    if [ "${CpuArch}" = aarch64 ]; then
        echo -e "\033[0;34m[aarch64]\033[0m"
        if [ "${KernelVersion}" = 4 ]; then
            if [ -e ./rpm/${packageName}-${RpmVersion}.aarch64.rpm ]; then
                echo -e "found\033[0;33m[${packageName}-${RpmVersion}.aarch64.rpm]\033[0m package."
                sudo rpm -ivh ./rpm/${packageName}-${RpmVersion}.aarch64.rpm --replacefiles --force
            else
                echo -e "\033[0;31m[${packageName}-${RpmVersion}.aarch64.rpm]\033[0m"
                echo -e "\033[0;31m ↑↑↑ target rpm no found! \033[0m"
            fi
        else
            echo -e "\033[0;31m ↑↑↑ target rpm no found! \033[0m"
        fi
    fi

    if [ "${CpuArch}" = mips64 ]; then
        echo -e "\033[0;34m[mips64el]\033[0m"
        if [ "${KernelVersion}" = 3 ]; then
            if [ -e ./rpm/${packageName}-${RpmVersion}.mips64el.rpm ]; then
                echo -e "found\033[0;33m[${packageName}-${RpmVersion}.mips64el.rpm]\033[0m package."
                sudo rpm -ivh ./rpm/${packageName}-${RpmVersion}.mips64el.rpm --replacefiles --force
            else
                echo -e "\033[0;31m[${packageName}-${RpmVersion}.mips64el.rpm]\033[0m"
                echo -e "\033[0;31m ↑↑↑ target rpm no found! \033[0m"
            fi
        else
            echo -e "\033[0;31m ↑↑↑ target rpm no found! \033[0m"
        fi
    fi
    sudo systemctl stop NetworkManager
#    sleep 3
    sudo test -d /etc/network/if-up.d && sudo cp -f ./tools/resetusbnicmetricdeb /etc/network/if-up.d/resetusbnicmetric${ShortName}
    sudo chmod 755 /etc/network/if-up.d/resetusbnicmetric${ShortName}
    sudo test -d /etc/NetworkManager/dispatcher.d && sudo cp -f ./tools/resetusbnicmetricrpm /etc/NetworkManager/dispatcher.d/resetusbnicmetric${ShortName} 
    sudo systemctl start NetworkManager
        
else
    echo "Unknown package manager!"
fi
